/*
===========================================================================
  CASL_support.h   Core include file for the CASL C support environment.


  This include file contains all of the core definitions needed to compile
  a C source file generated by the CASL compiler.  These definitions consist
  of #define, typedef, and function prototype definitions that are mandatory
  to compile any CASL program.  Another file, CASL_optional.h, contains the
  prototypes for functions that the generated C code MAY call, dependant
  upon what statements are used in the CASL program.
  
  Copyright(c) Feras Information Technologies (R), 1998, All rights reserved

===========================================================================

Modification history:
===========================================================================
Changed on 03/25/01: (CASL 3.2)
  Copied features from CASLrt for 3.2 support (flagged with #ifdef CASL_32)
  
Changed on 11/09/00: (version 3.1 beta)
  Added prototypes for _CASL_property_set, _CASL_property_num and _CASL_property_str

Changed on 07/15/00: (pre-release of event handling feature)
  Added prototype for CASLpro_event_handler.
  
Changed on 05/02/00: (CASLpro support of CASL 3.0)
  Added prototypes for _pda_focus, _pda_clipboard, _pda_rename_file, _pda_last_penx/y.
                       _pda_bitmap, and _CASL_attach_object_bitmap.
  
Changed on 02/12/00: (beta 6)
  Added conditional compilation for PalmOS 3.5 headers.
  
Changed on 07/31/99: (beta 5)
  Added prototype for pilot-specific support function to get the creator ID of the app.
  
Changed on 05/06/99: (beta 3)
  Added _pda_float_to_sdword prototype.
  
Changed on 04/10/99: (beta 2)
  Added CASL_var_string_make,_CASL_strcmp and _CASL_strlen prototypes.
  

Originally created 11/13/98
===========================================================================
*/
#ifndef CASL_SUPPORT_H

#define CASL_SUPPORT_H 1


/* PalmOS definitions */

#ifdef PILOTSDK

#define CASL_32 1
#define CASL_31 1

/* PalmOS interface include files */

#ifdef CASL_32
#include "palm_sdk_setup.h"
#endif

#ifdef PALMOS_NEW_SDK
#include <PalmOS.h>
#include <PalmCompatibility.h>
#else
#include <Pilot.h>		/* all the Pilot headers */ 
#endif

#include <FloatMgr.h>

#ifndef PALMOS_NEW_SDK
#include <NewFloatMgr.h> 
#endif

#ifdef PALMOS_NEW_SDK
#include <SerialMgr.h>
#include <SerialMgrOld.h>
#else
#include <SerialMgr.h>
#endif



#include <FeatureMgr.h>
#include <Graffiti.h>
#include <KeyMgr.h>

/* CASL datatypes that are referenced in the generated C code */

typedef char*  CASL_STRINGT;    /* null terminated string datatype */
typedef Byte   CASL_BYTE;      /* byte datatype */
typedef Word   CASL_WORD;      /* unsigned word datatype */
typedef SWord  CASL_SWORD;     /* signed word datatype */
typedef double CASL_FLOATNUM;  /* floating point datatype (double IEEE) */
typedef DWord  CASL_DWORD;     /* long word datatype */
typedef SDWord CASL_SDWORD;    /* signed long word datatype */

typedef Boolean  CASL_BOOL;    /* Boolean type and constants */
#define TRUE   1
#define FALSE  0

CASL_WORD _pda_strcmp(char *s1, char *s2);

#define _pda_strlen StrLen
#define _pda_strcat StrCat

#endif

#ifdef WIN32

typedef unsigned char  CASL_BYTE;	    /* byte datatype */
typedef unsigned short int CASL_WORD;	/* unsigned word datatype */
typedef short int CASL_SWORD;		    /* signed word datatype */
typedef double CASL_FLOATNUM;		    /* floating point datatype */
typedef unsigned long int CASL_DWORD;	/* long word datatype */
typedef long int CASL_SDWORD;		    /* signed long word datatype */

typedef char  CASL_BOOL;		        /* Boolean type and constants */
#define TRUE   1
#define FALSE  0

#if !defined(_WIN32_WCE)
#include <stdio.h>
#include <fcntl.h>		                /* file access symbolic constants */
#include <io.h>
#include <sys/stat.h>                   /* file status symbolic constants */
#endif

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

int _pda_strcmp( const char *string1, const char *string2 );

#endif

/* structure definition for conveying FIELD datatypes, sizes */
/*  and their associate CASL variable addresses              */

typedef struct casl_field_map
  {
  void *cfm_address;     /* address of the associated field variable */
  CASL_WORD cfm_type;    /* datatype of the assocated field variable */
  CASL_WORD cfm_size;    /* size of field variable (non-zero for array) */
  } CASL_FIELD_MAP;

/* external reference to constant pool */

extern CASL_BYTE  __casl_constants[];

/*
  Prototypes for support library functions called by the CASL C statements
  
  When compiling for multiple code segments with GCC, these are the segment
  definitions for linkage into the code segment that contains the support library.
  
  For Metrowerks, they are simply the C prototypes for the support library functions.
  
*/
#ifndef NO_SEGMENTS

#ifdef __GNUC__

#define CASL_SUPPORT_SECTION  __attribute__ ((section ("caslsupp")))
#define CASL_NETWORK_SECTION  __attribute__ ((section ("caslnetw")))

#else

#define CASL_SUPPORT_SECTION
#define CASL_NETWORK_SECTION

#endif

#else

#define CASL_SUPPORT_SECTION
#define CASL_NETWORK_SECTION

#endif



void _CASL_get(CASL_WORD objidx, CASL_WORD obj_sub_expr, CASL_WORD pcode, CASL_WORD datatype,
               void *varptr, CASL_WORD sub_expr, CASL_WORD len_expr)
   CASL_SUPPORT_SECTION;

void _CASL_put(CASL_WORD objidx, CASL_WORD obj_sub_expr, CASL_WORD pcode, CASL_WORD data_type,
               CASL_FLOATNUM numeric_expr, CASL_STRINGT string_expr, CASL_WORD len_expr)
   CASL_SUPPORT_SECTION;

void _CASL_put_buffer(CASL_WORD objidx, CASL_WORD obj_sub_expr,
                      CASL_BYTE *sym, CASL_WORD length, CASL_WORD pcode)
   CASL_SUPPORT_SECTION;
                      
void _CASL_move(CASL_WORD objidx, CASL_WORD obj_sub_expr,
                CASL_FLOATNUM x_expr, CASL_FLOATNUM y_expr)
   CASL_SUPPORT_SECTION;

void _CASL_do_graphic_cmd(CASL_WORD objidx, CASL_WORD obj_sub_expr,
                          CASL_WORD pcode, CASL_WORD shape_flag,
                          CASL_FLOATNUM x_expr, CASL_FLOATNUM y_expr)
   CASL_SUPPORT_SECTION;
              
void _CASL_attach_dbfile_fields(CASL_WORD objidx, void *field_map)
   CASL_SUPPORT_SECTION;

/* new for version 3.0 */

void _CASL_attach_object_bitmap
  (
  CASL_WORD objidx,      /* index into object table */
  CASL_WORD objsubidx,   /* subscript in object array */
#ifdef CASL_32
  CASL_WORD symidx,      /* bitmap symbol table index (used for resource) */
#endif  
  void *bitmap           /* address of the bitmap array */
  ) CASL_SUPPORT_SECTION;

/* end of version 3.0 new functions */

/* new for version 3.1 */

void _CASL_property_set
  (
  CASL_WORD objidx,
  CASL_WORD objsubidx,
  CASL_WORD property_idx,
  CASL_FLOATNUM num_value,
  CASL_STRINGT  str_value
  ) CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_property_num
  (
  CASL_WORD objidx,
  CASL_WORD objsubidx,
  CASL_WORD property_idx
  ) CASL_SUPPORT_SECTION;

CASL_STRINGT _CASL_property_str
  (
  CASL_WORD objidx,
  CASL_WORD objsubidx,
  CASL_WORD property_idx
  ) CASL_SUPPORT_SECTION;


/* end of version 3.0 new functions */

/* CASL generic support function prototypes (for CASL built-in functions) */

CASL_FLOATNUM _CASL_abs(CASL_FLOATNUM s)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_asc(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_char(CASL_FLOATNUM num)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_find(CASL_STRINGT s, CASL_STRINGT t, CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_trunc(CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_left(CASL_STRINGT s, CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_upper_lower(CASL_WORD pcode, CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_mid(CASL_STRINGT s, CASL_FLOATNUM m, CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_right(CASL_STRINGT s, CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_string(CASL_FLOATNUM n, CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM  _CASL_value(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_string_add(CASL_STRINGT s1, CASL_STRINGT s2)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_string_make(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_STRINGT  _CASL_var_string_make(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_strcmp(char *s1, char *s2)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _CASL_strlen(char *s)
   CASL_SUPPORT_SECTION;

/* pda-specific support function prototypes (for CASL statements) */

void _pda_show_object(CASL_WORD objidx, CASL_WORD obj_sub_expr)
   CASL_SUPPORT_SECTION;
void _pda_hide_object(CASL_WORD objidx, CASL_WORD obj_sub_expr)
   CASL_SUPPORT_SECTION;
void _pda_open_file(CASL_WORD objidx, CASL_WORD obj_sub_expr, CASL_STRINGT name_string_expr)
   CASL_SUPPORT_SECTION;
void _pda_close_file(CASL_WORD objidx, CASL_WORD obj_sub_expr)
   CASL_SUPPORT_SECTION;
void _pda_seek_file(CASL_WORD objidx, CASL_WORD obj_sub_expr, CASL_WORD seek_code,
                    CASL_FLOATNUM expr)
   CASL_SUPPORT_SECTION;
void _pda_delete_file(CASL_STRINGT name_expr)
   CASL_SUPPORT_SECTION;
void _pda_put_fields_or_insert(CASL_WORD objidx, CASL_WORD obj_sub_expr, CASL_WORD pcode)
   CASL_SUPPORT_SECTION;
void _pda_play(CASL_STRINGT string_expr)
   CASL_SUPPORT_SECTION;
void _pda_arm_timer(CASL_WORD func_index, CASL_FLOATNUM time_expr)
   CASL_SUPPORT_SECTION;
void _pda_launch(CASL_STRINGT string_expr)
   CASL_SUPPORT_SECTION;
void _pda_search_db(CASL_WORD objidx, CASL_WORD obj_sub_expr,
                    CASL_FLOATNUM numeric_expr, CASL_STRINGT string_expr)
   CASL_SUPPORT_SECTION;
void _pda_getfield(CASL_WORD objidx, CASL_WORD obj_sub_expr)
   CASL_SUPPORT_SECTION;
void _pda_remove_record(CASL_WORD objidx, CASL_WORD obj_sub_expr)
   CASL_SUPPORT_SECTION;

CASL_WORD _pda_float_to_word (CASL_FLOATNUM f1)
   CASL_SUPPORT_SECTION;
CASL_SDWORD _pda_float_to_sdword(CASL_FLOATNUM f1)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_sdword_to_float(CASL_SDWORD v1)
  CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_byte_to_float(CASL_BYTE b1)
   CASL_SUPPORT_SECTION;

void _pda_list_exec(CASL_WORD objidx, CASL_STRINGT *stringarray, CASL_WORD arraysize)
   CASL_SUPPORT_SECTION;

/* new 3.0 support functions */

void _pda_rename_file	(char *old_name, char *new_name)
   CASL_SUPPORT_SECTION;

void _pda_focus		       /* give focus to specified object */
  (
  CASL_WORD objidx,			 /*  index into object table */
  CASL_WORD objsubidx 	 /*  subscript in array of objects */
  ) CASL_SUPPORT_SECTION;

void _pda_clipboard
  (
  CASL_WORD pcode         /* the clipboard operation to do (specified by pcode value) */
  ) CASL_SUPPORT_SECTION;

CASL_FLOATNUM _pda_last_pen_x
  (
  void
  ) CASL_SUPPORT_SECTION;

CASL_FLOATNUM _pda_last_pen_y
  (
  void
  ) CASL_SUPPORT_SECTION;

void _pda_bitmap
  (
  CASL_WORD objidx,      /* index into object table */
  CASL_WORD objsubidx,   /* subscript in object array (ignored here) */
  CASL_WORD bitmap       /* bitmap byte array (ignored here) */
  ) CASL_SUPPORT_SECTION;

#ifdef CASL_32
void _pda_set_color
  (
  CASL_WORD token,         /* the foreground or background token */
  CASL_WORD objidx,        /* the object index */
  CASL_WORD objsubidx,     /* the object subscript */
  CASL_FLOATNUM the_color  /* the object color value */
  ) CASL_SUPPORT_SECTION;

CASL_FLOATNUM _pda_rgb
  (
  CASL_FLOATNUM redvalue,
  CASL_FLOATNUM greenvalue,
  CASL_FLOATNUM bluevalue
  )CASL_SUPPORT_SECTION;

CASL_FLOATNUM _pda_color_depth(void) CASL_SUPPORT_SECTION;
  

#endif



/* pda-specific support function prototypes (for CASL built-in functions) */

CASL_STRINGT  _pda_userpath(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_date_value(CASL_WORD pcode)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_elapsed_milliseconds(void)
   CASL_SUPPORT_SECTION;

CASL_FLOATNUM _pda_randomn(CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_exists(CASL_STRINGT s)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_message_box(CASL_FLOATNUM class, CASL_STRINGT caption, CASL_STRINGT descr,
                               CASL_STRINGT b1_label, CASL_STRINGT b2_label, CASL_STRINGT b3_label)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_get_category(void)
   CASL_SUPPORT_SECTION;
CASL_STRINGT  _pda_get_category_string(void)
   CASL_SUPPORT_SECTION;
CASL_FLOATNUM _pda_set_category(CASL_FLOATNUM n)
   CASL_SUPPORT_SECTION;

void *_pda_any_memory(CASL_DWORD size)  /* CASL memory allocator function */
  CASL_SUPPORT_SECTION;

void _pda_any_dispose(void *ptr)    /* CASL memory freeing function */
  CASL_SUPPORT_SECTION;

void _pda_unlock_bitmap(void *ptr)  /* bitmap segment unlocking function */
  CASL_SUPPORT_SECTION;

/* prototype for pilot-specific support function to get the creator ID of the app */

CASL_DWORD _pda_dbcreator_id();

/* prototype for CASLpro compiler generated function to init CASLpro app objects and vars */

void _pda_init_caslpro_app(void);

/* prototype for CASLpro compiler generated function to perform any app shutdown actions */

void _pda_shutdown_caslpro_app(void);

/* prototype for CASLpro event handler (coded in C by CASLpro developer, if present) */

Boolean CASLpro_event_handler(EventPtr evt);

#endif
